/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.ceutils;

import com.filenet.api.core.EngineObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.util.Encryption;
import java.security.Provider;
import java.security.Security;

class CryptoHelper {
    protected static final String JCE_PROVIDER_CLASS_NAME = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    protected static final String JCE_PROVIDER_NAME = "BC";
    private static boolean providerLoaded = false;

    CryptoHelper() {
    }

    public static void loadJCEProvider(EngineObject eo) {
        if (providerLoaded || eo == null) {
            return;
        }
        char[] plainText = new char[]{'t', 'e', 's', 't', 'i', 'n', 'g', '1', '2', '3'};
        try {
            Encryption.encrypt((EngineObject)eo, (char[])plainText);
        }
        catch (EngineRuntimeException ere) {
            if (null == Security.getProvider(JCE_PROVIDER_NAME)) {
                try {
                    Security.addProvider((Provider)Class.forName(JCE_PROVIDER_CLASS_NAME).newInstance());
                    providerLoaded = true;
                    Encryption.encrypt((EngineObject)eo, (char[])plainText);
                }
                catch (Exception e) {
                    System.out.println("An attempt to load the JCE provider failed: org.bouncycastle.jce.provider.BouncyCastleProvider");
                    System.out.println("Make sure this class is in your class path, or manually add a suitable JCE provider");
                    System.out.println("got exception " + e);
                }
            }
            System.out.println("Encryption failed even through JCE provider already loaded: org.bouncycastle.jce.provider.BouncyCastleProvider");
            System.out.println("got exception " + (Object)((Object)ere));
        }
    }
}

